jQuery(document).ready(function ($) {
    // Variables passed from wp_localize_script
    // seamless_webp_vars.total_count
    // seamless_webp_vars.nonce
    // seamless_webp_vars.ajaxurl (or window.ajaxurl)

    var total = parseInt(seamless_webp_vars.total_count) || 0;
    var offset = 0;
    var batchSize = 5;
    var processed = 0;
    var isTestMode = false;
    var ajaxUrl = seamless_webp_vars.ajaxurl;

    function startProcess(testMode) {
        isTestMode = testMode;
        $('#seamless-webp-start-btn, #seamless-webp-test-btn').prop('disabled', true);
        $('#seamless-webp-spinner').addClass('is-active');
        $('#seamless-webp-progress-wrap').show();
        $('#seamless-webp-msg').text(testMode ? seamless_webp_vars.strings.running_test : seamless_webp_vars.strings.starting);
        processBatch();
    }

    $('#seamless-webp-start-btn').on('click', function () {
        startProcess(false);
    });

    $('#seamless-webp-test-btn').on('click', function () {
        startProcess(true);
    });

    function processBatch() {
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: {
                action: 'seamless_webp_bulk_process',
                offset: offset,
                batch_size: batchSize,
                nonce: seamless_webp_vars.nonce
            },
            success: function (response) {
                if (response.success) {
                    var data = response.data;
                    var count = data.count;
                    processed += count;
                    offset += count;

                    var percent = (total > 0) ? Math.min(100, Math.round((processed / total) * 100)) : 0;
                    $('#seamless-webp-progress-bar').css('width', percent + '%');
                    $('#seamless-webp-count').text(processed);

                    if (isTestMode) {
                        finish(seamless_webp_vars.strings.test_complete);
                    } else if (count > 0) {
                        processBatch();
                    } else {
                        finish(seamless_webp_vars.strings.all_done);
                    }
                } else {
                    finish('Error: ' + (response.data || 'Unknown error'));
                }
            },
            error: function () {
                finish(seamless_webp_vars.strings.server_error);
            }
        });
    }

    $('#seamless-webp-enable-btn').on('click', function () {
        var $btn = $(this);
        $btn.prop('disabled', true).text(seamless_webp_vars.strings.enabling);

        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: {
                action: 'seamless_webp_save_htaccess',
                nonce: seamless_webp_vars.nonce
            },
            success: function (response) {
                if (response.success) {
                    $('#seamless-webp-htaccess-msg').html('<span style="color:green">' + response.data + ' ' + seamless_webp_vars.strings.refresh_hint + '</span>');
                    setTimeout(function () { location.reload(); }, 1500);
                } else {
                    $('#seamless-webp-htaccess-msg').html('<span style="color:red">Error: ' + response.data + '</span>');
                    $btn.prop('disabled', false).text(seamless_webp_vars.strings.enable_btn);
                }
            },
            error: function () {
                $('#seamless-webp-htaccess-msg').html('<span style="color:red">' + seamless_webp_vars.strings.server_error + '</span>');
                $btn.prop('disabled', false).text(seamless_webp_vars.strings.enable_btn);
            }
        });
    });

    function finish(msg) {
        $('#seamless-webp-progress-bar').css('width', isTestMode ? '100%' : '100%');
        $('#seamless-webp-start-btn, #seamless-webp-test-btn').prop('disabled', false).text(function () { return this.dataset.originalText || $(this).text(); });
        $('#seamless-webp-spinner').removeClass('is-active');
        $('#seamless-webp-msg').text(msg);
    }
});
